package de.ugoe.cs.eventbench.models;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;

import de.ugoe.cs.eventbench.data.Event;

public class HighOrderMarkovModel extends TrieBasedModel {
	
	/**
	 * Id for object serialization.
	 */
	private static final long serialVersionUID = 1L;

	public HighOrderMarkovModel(int maxOrder, Random r) {
		super(maxOrder, r);
	}
	
	@Override
	public double getProbability(List<Event<?>> context, Event<?> symbol) {
		double result = 0.0d;
		
		List<Event<?>> contextCopy;
		if( context.size()>=trieOrder ) {
			contextCopy = new LinkedList<Event<?>>(context.subList(context.size()-trieOrder+1, context.size()));
		} else {
			contextCopy = new LinkedList<Event<?>>(context);
		}

	
		List<Event<?>> followers = trie.getFollowingSymbols(contextCopy);
		int sumCountFollowers = 0; // N(s\sigma')
		for( Event<?> follower : followers ) {
			sumCountFollowers += trie.getCount(contextCopy, follower);
		}
		
		int countSymbol = trie.getCount(contextCopy, symbol);
		if( sumCountFollowers!=0 ) {
			result = ((double) countSymbol / sumCountFollowers);
		}
		
		return result;
	}

}
