package de.ugoe.cs.quest.plugin.guitar.commands;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.plugin.guitar.GUITARTestCaseParser;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to load a set of sequences from a set of GUITAR test cases.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDefgTestCasesToSequences implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String foldername;
		String sequencesName;
		String efgFileName = null;
		try {
			foldername = (String) parameters.get(0);
			sequencesName = (String) parameters.get(1);
			if (parameters.size() >= 3) {
				efgFileName = (String) parameters.get(2);
			}
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		File folder = new File(foldername);
		
		File[] testcaseFiles = folder.listFiles( new FilenameFilter() {
			@Override
			public boolean accept(File dir, String name) {
				return name.endsWith(".tst");
			}
		});
		Collection<List<Event>> sequences = new LinkedList<List<Event>>();
		GUITARTestCaseParser parser;
		if (efgFileName == null) {
			parser = new GUITARTestCaseParser();
		} else {
			parser = new GUITARTestCaseParser(efgFileName);
		}
		for (File testcaseFile : testcaseFiles) {
			Console.traceln(Level.INFO, "Loading from file "
					+ testcaseFile.getAbsolutePath());
			sequences.add(parser.parseTestCaseFile(testcaseFile));
		}
		if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
			CommandHelpers.dataOverwritten(sequencesName);
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "efgTestCasesToSequences <directory> <sequencesName> {<guiFileName>}";
	}

}
