package de.ugoe.cs.autoquest.htmlmonitor;

import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class HtmlMonitor implements HtmlMonitorComponent {

    /** */
    private int port = 8090;
    
    /** */
    private HtmlMonitorServer server;
    
    /** */
    private String logFileBaseDir;

    /** */
    private HtmlMonitorLogManager logManager;

    /** */
    private Thread shutdownHook;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param logFileBaseDir
     */
    HtmlMonitor(String[] commandLineArguments) {
        if (commandLineArguments.length > 0) {
            this.logFileBaseDir = commandLineArguments[0];
            Console.println("putting logs into directory " + this.logFileBaseDir);
        }
        
        if (commandLineArguments.length > 1) {
            try {
                this.port = Integer.parseInt(commandLineArguments[1]);
            }
            catch (NumberFormatException e) {
                Console.println("ignoring invalid port specification " + commandLineArguments[1]);
            }
            Console.println("listening on port " + this.port);
        }
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.htmlmonitor.HtmlMonitorComponent#init()
     */
    @Override
    public synchronized void init() throws HtmlMonitorException {
        if (server != null) {
            throw new IllegalStateException("already initialized.");
        }
        
        try {
            logManager = new HtmlMonitorLogManager(logFileBaseDir);
            logManager.init();
        
            server = new HtmlMonitorServer(port, logManager);
            server.init();
        
            shutdownHook = new Thread(new ShutdownHook(server, logManager));
        }
        catch (HtmlMonitorException e) {
            Console.printerrln("could not initialize HTML monitor: " + e);
            Console.logException(e);
        }
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.htmlmonitor.HtmlMonitorComponent#start()
     */
    @Override
    public synchronized void start() {
        if (server == null) {
            throw new IllegalStateException("not initialized.");
        }
        
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            logManager.start();
            server.start();
        }
        catch (HtmlMonitorException e) {
            Console.printerrln("could not start HTML monitor: " + e);
            Console.logException(e);
        }
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.htmlmonitor.HtmlMonitorComponent#stop()
     */
    @Override
    public synchronized void stop() {
        if (server == null) {
            throw new IllegalStateException("not initialized.");
        }
        
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
        server.stop();
        logManager.stop();
        
        server = null;
        logManager = null;
    }

}
