package de.ugoe.cs.autoquest.htmlmonitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class HtmlMonitorLogManager implements HtmlMonitorComponent, HtmlMonitorMessageListener {
    
    /**
     * 
     */
    private static final int SESSION_TIMEOUT = 100000;
    
    /**
     * 
     */
    private String logFileBaseDir;

    /**
     * 
     */
    private Map<String, HtmlMonitorOutputWriter> writers;

    /**
     * 
     */
    private Timer logFileMonitorTimer;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param logFileBaseDir
     */
    HtmlMonitorLogManager(String logFileBaseDir) {
        this.logFileBaseDir = logFileBaseDir;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.htmlmonitor.HtmlMonitorComponent#init()
     */
    @Override
    public synchronized void init() throws IllegalStateException, HtmlMonitorException {
        if (writers != null) {
            throw new IllegalStateException("already initialized");
        }
        
        writers = new HashMap<String, HtmlMonitorOutputWriter>();
        logFileMonitorTimer = new Timer();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.htmlmonitor.HtmlMonitorComponent#start()
     */
    @Override
    public synchronized void start() throws IllegalStateException, HtmlMonitorException {
        if (writers == null) {
            throw new IllegalStateException("not initialized");
        }
        
        logFileMonitorTimer.schedule
            (new LogFileMonitorTimerTask(), SESSION_TIMEOUT / 2, SESSION_TIMEOUT / 2);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.htmlmonitor.HtmlMonitorComponent#stop()
     */
    @Override
    public synchronized void stop() {
        if (writers != null) {
            logFileMonitorTimer.cancel();
            
            for (HtmlMonitorOutputWriter writer : writers.values()) {
                writer.stop();
            }
        }
        
        writers = null;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.htmlmonitor.HtmlMonitoringListener#handleEvents(de.ugoe.cs.quest.htmlmonitor.HtmlClientInfos, de.ugoe.cs.quest.htmlmonitor.HtmlEvent[])
     */
    @Override
    public void handleMessage(HtmlClientInfos clientInfos, HtmlEvent[] events) {
        HtmlMonitorOutputWriter writer = writers.get(clientInfos.getClientId());
        
        try {
            if (writer == null) {
                synchronized (this) {
                    writer = writers.get(clientInfos.getClientId());
                    if (writer == null) {
                        writer =
                            new HtmlMonitorOutputWriter(logFileBaseDir, clientInfos.getClientId());
                        writer.init();
                        writer.start();
                        writers.put(clientInfos.getClientId(), writer);
                    }
                }
            }

            writer.handleMessage(clientInfos, events);
        }
        catch (Exception e) {
            Console.printerrln("could not handle message of client " + clientInfos.getClientId() +
                               ": " + e);
            Console.logException(e);
            
            // determine, if the writer exists but is not able to log something. In this case,
            // destroy the writer (part of the message may be logged twice through this).
            writer = writers.get(clientInfos.getClientId());
            if (writer != null) {
                try {
                    writer.handleMessage(clientInfos, events);
                }
                catch (Exception e1) {
                    synchronized (this) {
                        writers.remove(clientInfos.getClientId());
                        writer.stop();
                    }
                }
            }
        }
    }

    /**
     * <p>
     * TODO comment
     * </p>
     * 
     * @author Patrick Harms
     */
    public class LogFileMonitorTimerTask extends TimerTask {

        /* (non-Javadoc)
         * @see java.lang.Runnable#run()
         */
        @Override
        public void run() {
            synchronized (HtmlMonitorLogManager.this) {
                List<String> timeoutSessions = new ArrayList<String>();
                for (Map.Entry<String, HtmlMonitorOutputWriter> entry : writers.entrySet()) {
                    HtmlMonitorOutputWriter writer = entry.getValue();
                    
                    if (System.currentTimeMillis() - writer.getLastUpdate() > SESSION_TIMEOUT) {
                        timeoutSessions.add(entry.getKey());
                    }
                }
                
                for (String clientId : timeoutSessions) {
                    HtmlMonitorOutputWriter writer = writers.remove(clientId);
                    writer.stop();
                }
            }
        }

    }

}
