package de.ugoe.cs.eventbench.windows;

import de.ugoe.cs.eventbench.IReplayDecorator;
import de.ugoe.cs.util.StringTools;

public class MFCReplayDecorator implements IReplayDecorator {

	/**
	 * Id for object serialization.
	 */
	private static final long serialVersionUID = 1L;
	
	transient private static MFCReplayDecorator theInstance;
	
	private MFCReplayDecorator() {};
	
	public static MFCReplayDecorator getInstance() {
		if( theInstance==null ) {
			theInstance = new MFCReplayDecorator();
		}
		return theInstance;
	}
	
	@Override
	public String getHeader() {
		return "<?xml version=\"1.0\" encoding=\"UTF-16\"?>" + StringTools.ENDLINE +
			   "<log>" + StringTools.ENDLINE;
		
	}

	@Override
	public String getFooter() {
		return "</log>" + StringTools.ENDLINE;
	}

	@Override
	public String getSessionHeader() {
		return " <session>" + StringTools.ENDLINE;
	}

	@Override
	public String getSessionFooter() {
		return " </session>" + StringTools.ENDLINE;
	}
	

}
