package de.ugoe.cs.autoquest.htmlmonitor;

/**
 * <p>
 * Exception to notify all irregularities, that are specific to the HTML monitor and its
 * components.
 * </p>
 * 
 * @author Patrick Harms
 */
public class HtmlMonitorException extends Exception {

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * initializes an exception with a simple message
     * </p>
     *
     * @param message the message of the exception
     */
    public HtmlMonitorException(String message) {
        super(message);
    }

    /**
     * <p>
     * initializes an exception with a simple message and a causing exception
     * </p>
     *
     * @param message the message of the exception
     * @param cause   the root cause of the exception
     */
    public HtmlMonitorException(String message, Throwable cause) {
        super(message, cause);
    }

}
