package de.ugoe.cs.autoquest.htmlmonitor;

/**
 * <p>
 * a message listener to be registered with the {@link HtmlMonitorServer} for being called for
 * new messages send by clients.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface HtmlMonitorMessageListener {

    /**
     * <p>
     * called for new messages received from a client. The client is described through the
     * <code>clientInfos</code>. The events are several events that were recorded at client side.
     * </p>
     *
     * @param clientInfos infos about the client that send the events
     * @param events      the received events
     */
    void handleMessage(HtmlClientInfos clientInfos, HtmlEvent[] events);

}
