package de.ugoe.cs.quest.plugin.guitar.eventcore;

import de.ugoe.cs.quest.IReplayDecorator;
import de.ugoe.cs.quest.eventcore.IReplayable;
import de.ugoe.cs.quest.plugin.guitar.EFGReplayDecorator;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * {@link IReplayable} used to generate test cases for the GUITAR suite.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class GUITARReplayable implements IReplayable {

    /**
     * <p>
     * EventId in the EFG and GUI files.
     * </p>
     */
    String eventId;

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new {@link GUITARReplayable}.
     * </p>
     * 
     * @param eventId
     */
    public GUITARReplayable(String eventId) {
        this.eventId = eventId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.eventcore.IReplayable#getReplay()
     */
    @Override
    public String getReplay() {
        StringBuilder replay = new StringBuilder();
        replay.append("<Step>" + StringTools.ENDLINE);
        replay.append("<EventId>" + eventId + "</EventId>" + StringTools.ENDLINE);
        replay.append("<ReachingStep>false</ReachingStep>" + StringTools.ENDLINE);
        replay.append("</Step>" + StringTools.ENDLINE);
        return replay.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.eventcore.IReplayable#getDecorator()
     */
    @Override
    public IReplayDecorator getDecorator() {
        return EFGReplayDecorator.getInstance();
    }

}
