package de.ugoe.cs.eventbench.commands;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDload implements Command {

	@Override
	public void run(List<Object> parameters) {
		String filename;
		try {
			filename = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		FileInputStream fis = null;
		ObjectInputStream in = null;
		try {
			fis = new FileInputStream(filename);
			in = new ObjectInputStream(fis);
			in.readObject();
			in.close();
		} catch (IOException ex) {
			ex.printStackTrace();
		} catch (ClassNotFoundException ex) {
			ex.printStackTrace();
		}
	}

	@Override
	public void help() {
		Console.println("Usage: loadObject <filename>");
	}
	
}
