
package de.ugoe.cs.util.console.defaultcommands;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.WordUtils;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Prints the manual of a command to the Console.
 * </p>
 * 
 * @version $Revision: $ $Date: Aug 30, 2012$
 * @author 2012, last modified by $Author: sherbold$
 */
public class CMDman implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String command;
        if (parameters.size() > 0) {
            command = (String) parameters.get(0);
        }
        else {
            throw new IllegalArgumentException();
        }

        Command cmd = CommandExecuter.getInstance().getCMD(command);

        if (cmd != null) {
            InputStream manStream =
                ClassLoader.getSystemResourceAsStream("manuals/" + command);
            if (manStream != null) {
                try {
                    Console.println(WordUtils.wrap(IOUtils.toString(manStream, "UTF-8"), 100).replace("$USAGE$", "Usage: " + cmd.help()));
                }
                catch (IOException e) {
                    Console.printerrln("Failure reading man page");
                    Console.logException(e);
                }
            }
            else {
                Console.println("Usage: " + help());
            }
        }
        else {
            Console.println("Command " + command + " not found.");
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "man <commandName>";
    }

}
