/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.interproc;

import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.IOException;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldPropertyDatabase<Property>
extends PropertyDatabase<FieldDescriptor, Property> {
    @Override
    protected FieldDescriptor parseKey(String s) throws PropertyDatabaseFormatException {
        int accessFlags;
        String[] tuple = s.split(",");
        if (tuple.length != 4) {
            throw new PropertyDatabaseFormatException("Invalid field tuple: " + s);
        }
        String className = XFactory.canonicalizeString(tuple[0]);
        String fieldName = XFactory.canonicalizeString(tuple[1]);
        String signature = XFactory.canonicalizeString(tuple[2]);
        try {
            accessFlags = Integer.parseInt(tuple[3]);
        }
        catch (NumberFormatException e) {
            throw new PropertyDatabaseFormatException("Invalid field access flags: " + tuple[3]);
        }
        return DescriptorFactory.instance().getFieldDescriptor(ClassName.toSlashedClassName(className), fieldName, signature, (accessFlags & 8) != 0);
    }

    @Override
    protected void writeKey(Writer writer, FieldDescriptor key) throws IOException {
        writer.write(key.getClassDescriptor().getDottedClassName());
        writer.write(",");
        writer.write(key.getName());
        writer.write(",");
        writer.write(key.getSignature());
        writer.write(",");
        XField xField = XFactory.createXField(key);
        int flags = xField.getAccessFlags() & 0xF;
        writer.write(String.valueOf(flags));
    }
}

