package de.ugoe.cs.quest.tasktrees.temporalrelation;

import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNodeFactory;

/**
 * <p>
 * a temporal relation ship is able to detected temporal relationships between the child nodes
 * of the parent node provided to the
 * {@link #apply(ITaskTreeNode, ITaskTreeBuilder, ITaskTreeNodeFactory, boolean)} method. A rule
 * created temporal relationships between the child nodes, i.e. substructures in the task tree, if
 * it detects a temporal relationship and it can be sure that it is complete. Incomplete but
 * detected temporal relationships may occur, if there can be more children expected to be added
 * to the provided parent node. This could be the case during parsing a interaction log file of
 * a GUI.
 * </p>
 * 
 * @author Patrick Harms
 */
interface TemporalRelationshipRule {

  /**
   * <p>
   * applies the rule to the given parent node. The provided builder and node factory are used
   * to create substructures in the task tree for the identified temporal relationships. The
   * finalize parameter is used to command the rule to finish rule applications, in the case it
   * is known that no further data will be available. 
   * </p>
   * <p>
   * The returned rule application result is null, if the rule can not be applied, i.e. it does not
   * detect a temporal relationship. It returns a rule application result with a status
   * {@link RuleApplicationStatus#RULE_APPLICATION_FINISHED} if the rule was applied. The result
   * contains all newly created parent nodes. It returns a rule application result with status
   * {@link RuleApplicationStatus#RULE_APPLICATION_FEASIBLE} if the rule would be applicable if
   * further children would be available in the parent node. This status MUST not be returned if 
   * the finalize parameter is true. In this case the rule must be applied or not. 
   * </p>
   * 
   * @param parent      the parent node with the children to apply the rule on
   * @param builder     the builder to be used for creating substructures for the identified
   *                    temporal relationships
   * @param nodeFactory the node factory to be used for creating substructures for the identified
   *                    temporal relationships
   * @param finalize    true, if the rule shall not expect further children to come and that it
   *                    should therefore be applied in any case
   *                    
   * @return the rule application result as described.
   */
  RuleApplicationResult apply(ITaskTreeNode        parent,
                              ITaskTreeBuilder     builder,
                              ITaskTreeNodeFactory nodeFactory,
                              boolean              finalize);
  
}
