
package de.ugoe.cs.quest.plugin.jfc.guimodel;

import de.ugoe.cs.quest.eventcore.guimodel.ITextField;

/**
 * <p>
 * Class that represents text fields in JFC GUIs.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class JFCTextField extends JFCGUIElement implements ITextField {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new JFCTextField.
     * </p>
     * 
     * @param specification
     *            specification of created GUI element
     * @param parent
     *            parent of the created GUI element; null means that the element is a top-level
     *            window
     */
    public JFCTextField(JFCGUIElementSpec specification, JFCGUIElement parent) {
        super(specification, parent);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.plugin.jfc.guimodel.JFCGUIElement#getElementDescriptor()
     */
    @Override
    protected String getElementDescriptor() {
        return "TextField";
    }
}
