/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import edu.umd.cs.findbugs.SystemProperties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryFilteringBugReporter
extends DelegatingBugReporter {
    private static final boolean DEBUG = SystemProperties.getBoolean("cfbreporter.debug");
    private Set<String> categorySet;

    public CategoryFilteringBugReporter(BugReporter realBugReporter, Set<String> categorySet) {
        super(realBugReporter);
        this.categorySet = categorySet;
    }

    @Override
    public void reportBug(BugInstance bugInstance) {
        BugPattern bugPattern = bugInstance.getBugPattern();
        String category = bugPattern.getCategory();
        if (this.categorySet.contains(category)) {
            this.getDelegate().reportBug(bugInstance);
        } else if (DEBUG) {
            System.out.println("CategoryFilteringBugReporter: filtered due to category " + category);
        }
    }
}

