package de.ugoe.cs.quest.eventcore.guimodel;

/**
 * <p>
 * Common interface for GUI element factories. 
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public interface IGUIElementFactory {

    /**
     * <p>
     * Instantiates a new {@link IGUIElement} from a given specification.
     * </p>
     * 
     * @param specification
     *            specification of the new GUI element
     * @param parent
     *            parent of the new GUI element
     * @return created GUI element
     * @throws GUIModelConfigurationException
     *             thrown if there is a problem during the creation of the GUI element
     */
    public IGUIElement instantiateGUIElement(IGUIElementSpec specification, IGUIElement parent)
        throws GUIModelConfigurationException;
    
}
