package de.ugoe.cs.eventbench.models;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

import de.ugoe.cs.eventbench.data.Event;

public interface IStochasticProcess extends Serializable {
	
	double getProbability(List<Event<?>> context, Event<?> symbol);

	public List<? extends Event<?>> randomSequence();
	
	public int getNumStates();
	
	public String[] getStateStrings();
	
	public Set<Event<?>> getEvents();

}