package de.ugoe.cs.quest.plugin.mfc;

import de.ugoe.cs.quest.plugin.mfc.guimodel.WindowTree;

/**
 * <p>
 * Handles {@code WM_SETTEXT} messages. Handler maintains the {@link WindowTree}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class HandlerSetText extends MessageHandler {

    /**
     * <p>
     * Constructor. Creates a new HanderSetText.
     * </p>
     * 
     * @param windowTree
     *            the tree of GUI element specifications to be created and adapted during parsing
     */
    public HandlerSetText(WindowTree windowTree) {
        super(windowTree);
    }

    /**
     * <p>
     * New name of the window.
     * </p>
     */
    private String windowName;

    /**
     * <p>
     * HWND of the window.
     * </p>
     */
    private long hwnd;

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.plugin.mfc.MessageHandler#onEndElement()
     */
    @Override
    public void onEndElement() {
        if (hwnd != 0) {
            super.getWindowTree().setName(hwnd, windowName);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.plugin.mfc.MessageHandler#onParameter(java.lang.String ,
     * java.lang.String)
     */
    @Override
    public void onParameter(String name, String value) {
        if (name.equals("window.hwnd")) {
            hwnd = Long.parseLong(value);
        }
        else if (name.equals("window.newText")) {
            windowName = value;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.plugin.mfc.MessageHandler#onStartElement()
     */
    @Override
    public void onStartElement() {
        windowName = "";
        hwnd = 0;
    }
}
