package de.ugoe.cs.quest.tasktrees.nodeequality;

import static org.junit.Assert.*;

import org.junit.Test;

/**
 * @author Patrick Harms
 */
public class NodeEqualityTest {

    /**
     *
     */
    @Test
    public void test() {
        assertTrue(NodeEquality.IDENTICAL.isAtLeast(NodeEquality.IDENTICAL));
        assertTrue(NodeEquality.IDENTICAL.isAtLeast(NodeEquality.LEXICALLY_EQUAL));
        assertTrue(NodeEquality.IDENTICAL.isAtLeast(NodeEquality.SYNTACTICALLY_EQUAL));
        assertTrue(NodeEquality.IDENTICAL.isAtLeast(NodeEquality.SEMANTICALLY_EQUAL));
        assertFalse(NodeEquality.IDENTICAL.isAtLeast(NodeEquality.UNEQUAL));

        assertFalse(NodeEquality.LEXICALLY_EQUAL.isAtLeast(NodeEquality.IDENTICAL));
        assertTrue(NodeEquality.LEXICALLY_EQUAL.isAtLeast(NodeEquality.LEXICALLY_EQUAL));
        assertTrue(NodeEquality.LEXICALLY_EQUAL.isAtLeast(NodeEquality.SYNTACTICALLY_EQUAL));
        assertTrue(NodeEquality.LEXICALLY_EQUAL.isAtLeast(NodeEquality.SEMANTICALLY_EQUAL));
        assertFalse(NodeEquality.LEXICALLY_EQUAL.isAtLeast(NodeEquality.UNEQUAL));

        assertFalse(NodeEquality.SYNTACTICALLY_EQUAL.isAtLeast(NodeEquality.IDENTICAL));
        assertFalse(NodeEquality.SYNTACTICALLY_EQUAL.isAtLeast(NodeEquality.LEXICALLY_EQUAL));
        assertTrue(NodeEquality.SYNTACTICALLY_EQUAL.isAtLeast(NodeEquality.SYNTACTICALLY_EQUAL));
        assertTrue(NodeEquality.SYNTACTICALLY_EQUAL.isAtLeast(NodeEquality.SEMANTICALLY_EQUAL));
        assertFalse(NodeEquality.SYNTACTICALLY_EQUAL.isAtLeast(NodeEquality.UNEQUAL));

        assertFalse(NodeEquality.SEMANTICALLY_EQUAL.isAtLeast(NodeEquality.IDENTICAL));
        assertFalse(NodeEquality.SEMANTICALLY_EQUAL.isAtLeast(NodeEquality.LEXICALLY_EQUAL));
        assertFalse(NodeEquality.SEMANTICALLY_EQUAL.isAtLeast(NodeEquality.SYNTACTICALLY_EQUAL));
        assertTrue(NodeEquality.SEMANTICALLY_EQUAL.isAtLeast(NodeEquality.SEMANTICALLY_EQUAL));
        assertFalse(NodeEquality.SEMANTICALLY_EQUAL.isAtLeast(NodeEquality.UNEQUAL));

        assertFalse(NodeEquality.UNEQUAL.isAtLeast(NodeEquality.IDENTICAL));
        assertFalse(NodeEquality.UNEQUAL.isAtLeast(NodeEquality.LEXICALLY_EQUAL));
        assertFalse(NodeEquality.UNEQUAL.isAtLeast(NodeEquality.SYNTACTICALLY_EQUAL));
        assertFalse(NodeEquality.UNEQUAL.isAtLeast(NodeEquality.SEMANTICALLY_EQUAL));
        assertTrue(NodeEquality.UNEQUAL.isAtLeast(NodeEquality.UNEQUAL));
    }

}
