
package de.ugoe.cs.quest.plugin.guitar.eventcore;

import de.ugoe.cs.quest.eventcore.IEventType;

/**
 * <p>
 * Event type of GUITAR events. The types are defined by eventIds.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public class GUITAREventType implements IEventType {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * GUITAR eventId of the event type.
     * </p>
     */
    String guitarEventId;

    /**
     * <p>
     * Constructor. Creates a new {@link GUITAREventType}.
     * </p>
     * 
     * @param eventId
     *            eventId of the event type
     */
    public GUITAREventType(String eventId) {
        this.guitarEventId = eventId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.eventcore.IEventType#getName()
     */
    @Override
    public String getName() {
        return "GUITAREventType";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return guitarEventId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GUITAREventType) {
            if (guitarEventId != null) {
                return guitarEventId.equals(((GUITAREventType) obj).guitarEventId);
            }
            else {
                return ((GUITAREventType) obj).guitarEventId == null;
            }
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        int hash = 37;
        if (guitarEventId != null) {
            hash = guitarEventId.hashCode();
        }
        return hash;
    }

}
