package de.ugoe.cs.quest.plugin;

import java.util.List;

/**
 * <p>
 * Interface for QUEST plug-ins.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface QuestPlugin {

	/**
	 * <p>
	 * Title of the plug-in.
	 * </p>
	 * 
	 * @return the title
	 */
	public String getTitle();

	/**
	 * <p>
	 * {@link List} of {@link String}s that contain the commands defined by this
	 * plug-in. The List is immutable.
	 * </p>
	 * <p>
	 * Consult the de.ugoe.cs.utils.console package of the java-utils project
	 * for more information.
	 * </p>
	 * 
	 * @return the command packages
	 */
	public List<String> getCommandPackages();
}
