/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.collection.PredicatedCollection;
import org.apache.commons.collections15.iterators.AbstractListIteratorDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicatedList<E>
extends PredicatedCollection<E>
implements List<E> {
    private static final long serialVersionUID = -5722039223898659102L;

    public static <E> List<E> decorate(List<E> list, Predicate<? super E> predicate) {
        return new PredicatedList<E>(list, predicate);
    }

    protected PredicatedList(List<E> list, Predicate<? super E> predicate) {
        super(list, predicate);
    }

    protected List<E> getList() {
        return (List)this.getCollection();
    }

    @Override
    public E get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int indexOf(Object object) {
        return this.getList().indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getList().lastIndexOf(object);
    }

    @Override
    public E remove(int index) {
        return this.getList().remove(index);
    }

    @Override
    public void add(int index, E object) {
        this.validate(object);
        this.getList().add(index, object);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        Iterator<E> it = coll.iterator();
        while (it.hasNext()) {
            this.validate(it.next());
        }
        return this.getList().addAll(index, coll);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int i) {
        return new PredicatedListIterator(this.getList().listIterator(i));
    }

    @Override
    public E set(int index, E object) {
        this.validate(object);
        return this.getList().set(index, object);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List<E> sub = this.getList().subList(fromIndex, toIndex);
        return new PredicatedList<E>(sub, this.predicate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PredicatedListIterator
    extends AbstractListIteratorDecorator<E> {
        protected PredicatedListIterator(ListIterator<E> iterator) {
            super(iterator);
        }

        @Override
        public void add(E object) {
            PredicatedList.this.validate(object);
            this.iterator.add(object);
        }

        @Override
        public void set(E object) {
            PredicatedList.this.validate(object);
            this.iterator.set(object);
        }
    }
}

