package de.ugoe.cs.autoquest.htmlmonitor;

/**
 * <p>
 * used to be able to shut down any {@link HtmlMonitorComponent} that must be stopped if the
 * application stops.
 * </p>
 * 
 * @author Patrick Harms
 */
public class ShutdownHook implements Runnable {

    /**
     * the components to be stopped on shutdown
     */
    private HtmlMonitorComponent[] components;
    
    /**
     * <p>
     * initializes the shutdown hook with the components to be shut down on shutdown of the whole
     * application
     * </p>
     *
     */
    public ShutdownHook(HtmlMonitorComponent... components) {
        this.components = components;
    }

    /* (non-Javadoc)
     * @see java.lang.Thread#run()
     */
    @Override
    public void run() {
        for (HtmlMonitorComponent component : components) {
            if (component != null) {
                component.stop();
            }
        }
    }

}
