package de.ugoe.cs.autoquest.htmlmonitor;

import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.TextConsole;

/**
 * <p>
 * implements the main method to start the {@link HtmlMonitor}.
 * </p>
 * 
 * @author Patrick Harms
 * @version 1.0
 */
public class Runner {

    /**
     * <p>
     * Main method of the application.
     * </p>
     * 
     * @param args command line arguments
     */
    public static void main(String[] args) {
        new TextConsole();
        
        HtmlMonitor monitor = new HtmlMonitor(args);
        try {
            monitor.init();
        }
        catch (HtmlMonitorException e) {
            Console.printerrln("could not initialize HTML monitor server: " + e.getMessage());
            Console.logException(e);
        }
        
        monitor.start();
    }
}
