package de.ugoe.cs.tasktree.keyboardmaps;

import java.util.Locale;

/**
 * <p>
 * Creates keyboard maps.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class KeyboardMapFactory {

    /**
     * <p>
     * Constructor. Private to prevent initialization of this class.
     * </p>
     */
    private KeyboardMapFactory() {
    }

    /**
     * <p>
     * Returns a {@link KeyboardMap} for the given {@link Locale}.
     * </p>
     *
     * @param locale the locale
     * @return the keyboard map
     */
    public static KeyboardMap createKeyboardMap(Locale locale) {
        KeyboardMap keyboardMap = new KeyboardMap(locale);
        keyboardMap.init();
        return keyboardMap;
    }
}
