package de.ugoe.cs.quest.plugin.mfc;

import de.ugoe.cs.quest.plugin.mfc.guimodel.WindowTree;

/**
 * <p>
 * Handler for {@code WM_DESTROY} message. The handler maintains the {@link WindowTree}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class HandlerDestroy extends MessageHandler {

    /**
     * <p>
     * Constructor. Creates a new HandlerDestroy.
     * </p>
     * 
     * @param windowTree
     *            the tree of GUI element specifications to be created and adapted during parsing
     */
    public HandlerDestroy(WindowTree windowTree) {
        super(windowTree);
    }

    /**
     * <p>
     * HWND of the window that is destroyed.
     * </p>
     */
    private long hwnd;

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.plugin.mfc.MessageHandler#onEndElement()
     */
    @Override
    public void onEndElement() {
        if (hwnd != 0) {
            super.getWindowTree().remove(hwnd);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.plugin.mfc.MessageHandler#onParameter(java.lang.String ,
     * java.lang.String)
     */
    @Override
    public void onParameter(String name, String value) {
        if (name.equals("window.hwnd")) {
            hwnd = Long.parseLong(value);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.plugin.mfc.MessageHandler#onStartElement()
     */
    @Override
    public void onStartElement() {
        hwnd = 0;
    }

}
