package de.ugoe.cs.quest.commands.misc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command that loads a previously serialized {@link GlobalDataContainer}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDload implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		try {
			filename = (String) parameters.get(0);
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		FileInputStream fis = null;
		ObjectInputStream in = null;
		try {
			fis = new FileInputStream(filename);
			in = new ObjectInputStream(fis);
			in.readObject();
			in.close();
		} catch (IOException ex) {
			Console.logException(ex);
		} catch (ClassNotFoundException ex) {
			Console.logException(ex);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "load <filename>";
	}

}
