package de.ugoe.cs.autoquest.tasktrees.nodeequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeAndIterationComparisonRule;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEquality;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNodeFactory;

/**
 * @author Patrick Harms
 */
public class NodeAndIterationComparisonRuleTest {

    /**
     *
     */
    @Test
    public void test() {
        NodeEqualityRuleManager manager = new NodeEqualityRuleManager();
        manager.init();
        
        ITaskTreeNodeFactory treeNodeFactory = new TaskTreeNodeFactory();
        ITaskTreeBuilder treeBuilder = new TaskTreeBuilder();
        
        NodeAndIterationComparisonRule rule = new NodeAndIterationComparisonRule(manager);
        
        ITaskTreeNode task1 = new TaskTreeNode("task1");
        
        assertNull(rule.compare(task1, task1));
        
        IIteration iteration1 = treeNodeFactory.createNewIteration();
        assertNull(rule.compare(iteration1, iteration1));
        assertNull(rule.compare(task1, iteration1));
        assertNull(rule.compare(iteration1, task1));

        treeBuilder.setChild(iteration1, task1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, task1));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(task1, iteration1));
        
        ISelection selection1 = treeNodeFactory.createNewSelection();
        treeBuilder.addChild(selection1, task1);
        treeBuilder.setChild(iteration1, selection1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, task1));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(task1, iteration1));
    }

}
