
package de.ugoe.cs.autoquest.plugin.guitar.eventcore;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;

/**
 * <p>
 * Event target for GUITAR events. The targets are described by a widgetId.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public class GUITAREventTarget implements IEventTarget {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Id of the widget, which can be looked up in a GUITAR .gui file.
     * </p>
     */
    private String widgetId;

    /**
     * <p>
     * Constructor. Creates a new {@link GUITAREventTarget}.
     * </p>
     * 
     * @param widgetId
     *            widget id of the target
     */
    public GUITAREventTarget(String widgetId) {
        this.widgetId = widgetId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getPlatform()
     */
    @Override
    public String getPlatform() {
        return "GUITAR";
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getStringIdentifier()
     */
    @Override
    public String getStringIdentifier() {
        return this.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return widgetId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GUITAREventTarget) {
            if (widgetId != null) {
                return widgetId.equals(((GUITAREventTarget) obj).widgetId);
            }
            else {
                return ((GUITAREventTarget) obj).widgetId == null;
            }
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        int hash = 13;
        if (widgetId != null) {
            hash = widgetId.hashCode();
        }
        return hash;
    }

}
