
package de.ugoe.cs.autoquest.plugin.jfc.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.IMenu;

/**
 * <p>
 * Class that represents menus in JFC GUIs.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class JFCMenu extends JFCGUIElement implements IMenu {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new JFCMenu.
     * </p>
     * 
     * @param specification
     *            specification of created GUI element
     * @param parent
     *            parent of the created GUI element; null means that the element is a top-level
     *            window
     */
    public JFCMenu(JFCGUIElementSpec specification, JFCGUIElement parent) {
        super(specification, parent);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.plugin.jfc.guimodel.JFCGUIElement#getElementDescriptor()
     */
    @Override
    protected String getElementDescriptor() {
        return "Menu";
    }

}
