package de.ugoe.cs.autoquest.plugin.mfc.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

import de.ugoe.cs.autoquest.plugin.mfc.LogPreprocessor;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to pre-process all files in a folder.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDconvertDirToXml implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "convertDirToXml <sourceDirectory> <targetFile> {<base64>}";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		if (parameters.size() < 2) {
			throw new IllegalArgumentException();
		}
		String path = (String) parameters.get(0);
		String target = (String) parameters.get(1);
		boolean base64 = false;
		if (parameters.size() == 3) {
			base64 = Boolean.parseBoolean((String) parameters.get(2));
		}

		try {
			new LogPreprocessor(base64).convertDirToXml(path, target);
		} catch (FileNotFoundException e) {
			Console.printerrln(e.getMessage());
		} catch (IOException e) {
			Console.printerrln(e.getMessage());
		}

	}

}
