package de.ugoe.cs.autoquest.plugin.php;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import de.ugoe.cs.autoquest.plugin.QuestPlugin;

/**
 * <p>
 * Identifier class for the QUEST PHP plug-in.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class PHPPlugin implements QuestPlugin {

	/**
	 * <p>
	 * The command packages of this plug-in.
	 * </p>
	 */
	private final static String[] commandPackages = new String[] { "de.ugoe.cs.autoquest.plugin.php.commands" };

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.plugin.QuestPlugin#getTitle()
	 */
	@Override
	public String getTitle() {
		return "GUITAR-Plugin";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.plugin.QuestPlugin#getCommandPackages()
	 */
	@Override
	public List<String> getCommandPackages() {
	        return Collections.unmodifiableList(Arrays.asList(commandPackages));
	}
}
