
package de.ugoe.cs.autoquest.plugin.php.eventcore;

import java.util.List;

import de.ugoe.cs.autoquest.eventcore.IEventType;

/**
 * <p>
 * Event type for PHP web requests.
 * </p>
 * 
 * @version $Revision: $ $Date: Aug 16, 2012$
 * @author 2012, last modified by $Author: sherbold$
 */
public class PHPEventType implements IEventType {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Path of the web request.
     * </p>
     */
    private final String path;

    /**
     * <p>
     * List of post variable names posted with the request.
     * </p>
     */
    private final List<String> postVars;

    /**
     * <p>
     * List of get variable names posted with the request.
     * </p>
     */
    private final List<String> getVars;

    /**
     * <p>
     * Constructor. Creates a new PHPEventType from a given path, a list of post variables, and a
     * list of get variables.
     * </p>
     * 
     * @param path
     *            path of the URI of the event
     * @param postVars
     *            POST variables send with the event
     * @param getVars
     *            GET variables send with the event
     */
    public PHPEventType(String path, List<String> postVars, List<String> getVars) {
        this.path = path;
        this.postVars = postVars;
        this.getVars = getVars;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventType#getName()
     */
    @Override
    public String getName() {
        return "PHPEventType";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String str = path;
        if (getVars != null && !getVars.isEmpty()) {
            str += "+GET" + getVars.toString().replace(" ", "");
        }
        if (postVars != null && !postVars.isEmpty()) {
            str += "+POST" + postVars.toString().replace(" ", "");
        }
        return str;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PHPEventType) {
            PHPEventType other = (PHPEventType) obj;
            return ((path == other.path) || (path != null && path.equals(other.path))) &&
                ((postVars == other.postVars) || (postVars!=null && postVars.equals(other.postVars))) &&
                ((getVars == other.getVars) || (getVars!=null && getVars.equals(other.getVars)));
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        int hash = 17;
        int multiplier = 7;
        if (path != null) {
            hash = hash * multiplier + path.hashCode();
        }
        if (postVars != null) {
            hash = hash * multiplier + postVars.hashCode();
        }
        if (getVars != null) {
            hash = hash * multiplier + getVars.hashCode();
        }
        return hash;
    }

}
