// Module    : $RCSfile: CommandRunner.java,v $
// Version   : $Revision: 0.0 $  $Author: pharms $  $Date: 29.08.2012 $
// Project   : quest-test-utils
// Creation  : 2012 by pharms
// Copyright : Patrick Harms, 2012
package de.ugoe.cs.autoquest.test;

import static org.junit.Assert.fail;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.util.console.Command;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @version $Revision: $ $Date: 29.08.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class CommandRunner {

    /**
     * <p>
     * prevent instantiation
     * </p>
     */
    private CommandRunner() {
        // just to prevent instantiation
    }

    public static void runCommand(Class<? extends Command> commandType, Object... parameters) {
        Command command;
        try {
            command = commandType.newInstance();
        }
        catch (Exception e) {
            fail("could not instantiate command");
            return; // just added to prevent compiler warning. But the fail will already throw an
                    // exception
        }
        
        List<Object> params = new ArrayList<Object>();
        
        for (Object parameter : parameters) {
            params.add(parameter);
        }
        
        command.run(params);
    }
}
