
package de.ugoe.cs.autoquest.ui.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;

import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @version $Revision: $ $Date: Aug 28, 2012$
 * @author 2012, last modified by $Author: sherbold$
 */
public class GuiModelTabComposite extends Composite {

    List guiModelList;

    /**
     * Create the composite.
     * 
     * @param parent
     * @param style
     */
    public GuiModelTabComposite(Composite parent, int style) {
        super(parent, style);
        createContents();
    }

    private void createContents() {
        setLayout(new GridLayout(5, false));

        guiModelList = new List(this, SWT.BORDER | SWT.V_SCROLL);
        guiModelList.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));

        Button btnShow = new Button(this, SWT.NONE);
        btnShow.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                // TODO
                String[] selectedStrings = guiModelList.getSelection();
                if (selectedStrings.length == 0) {
                    SWTHelpers.noSelectionError(getShell());
                    return;
                }
                String modelName = selectedStrings[0];
                GUIModel model = (GUIModel) GlobalDataContainer.getInstance().getData(modelName);

                ShowGuiModelDialog showGuiModelDialog =
                    new ShowGuiModelDialog(getShell(), SWT.NONE, model, modelName);
                showGuiModelDialog.open();
            }
        });
        btnShow.setText("Show");

        Button btnDelete_1 = new Button(this, SWT.NONE);
        btnDelete_1.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                if (SWTHelpers.deleteSelectedFromStorage(guiModelList)) {
                    updateModelList();
                }
                else {
                    SWTHelpers.noSelectionError(getShell());
                }
            }
        });
        btnDelete_1.setText("Delete");
    }

    @Override
    protected void checkSubclass() {
        // Disable the check that prevents subclassing of SWT components
    }

    public void updateModelList() {
        guiModelList.removeAll();
        for(String key : GlobalDataContainer.getInstance().getAllKeys()) {
            if( GlobalDataContainer.getInstance().getData(key) instanceof GUIModel ) {
                guiModelList.add(key);
            }
        }
    }

}
