
package de.ugoe.cs.autoquest.eventcore.gui;

import de.ugoe.cs.autoquest.keyboardmaps.VirtualKey;

/**
 * <p>
 * Base class for all keyboard interaction event types.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public abstract class KeyInteraction implements IInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * the key associated with the interaction
     * </p>
     */
    private VirtualKey key;

    /**
     * <p>
     * Constructor. Creates a new KeyInteraction.
     * </p>
     * 
     * @param key
     *            key associated with the interaction
     */
    public KeyInteraction(VirtualKey key) {
        super();
        this.key = key;
    }

    /**
     * <p>
     * Returns the key associated with the interaction.
     * </p>
     * 
     * @return the key
     */
    public VirtualKey getKey() {
        return key;
    }

}
