
package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;

/**
 * <p>
 * Common interface for all GUI elements.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public interface IGUIElement extends IEventTarget {

    /**
     * <p>
     * Returns the specification of the GUI element.
     * </p>
     * 
     * @return the specification
     */
    public IGUIElementSpec getSpecification();

    /**
     * <p>
     * Returns the parent of the GUI element.
     * </p>
     * 
     * @return the parent
     */
    public IGUIElement getParent();

    /**
     * <p>
     * Defines that {@link IGUIElement} implementations have to define equals.
     * </p>
     * 
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object other);

    /**
     * <p>
     * Defines that {@link IGUIElement} implementations have to define hashCode.
     * </p>
     * 
     * @see Object#hashCode()
     */
    @Override
    public int hashCode();

    /**
     * <p>
     * Updates the specification of a GUI element with another specification, e.g., to add further
     * known names of the GUI element.
     * </p>
     * 
     * @param furtherSpec
     *            additional specification
     */
    public void updateSpecification(IGUIElementSpec furtherSpec);

    /**
     * <p>
     * The {@link IGUIElement} that is passed by this function is equal to the current GUI element
     * and will hereafter be treated as such.
     * </p>
     * 
     * @param guiElement
     *            GUI element that is equal
     */
    public void addEqualGUIElement(IGUIElement equalElement);
}
