package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.tasktrees.TaskTreeChecker;
import de.ugoe.cs.autoquest.test.DummyGUIElement;
import de.ugoe.cs.autoquest.test.DummyInteraction;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class DefaultGuiElementSequenceDetectionRuleTest extends AbstractTemporalRelationshipTC {
    
    /**
     *
     */
    @Test
    public void testOneInteractionOnOneElement() {
        simulateEvent(new DummyInteraction("bla", 1), new DummyGUIElement("elem1"));

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence {" +
             "  Event bla {}" +
             "}", getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testManyInteractionsOnOneElement() {
        IEventTarget eventTarget = new DummyGUIElement("elem1");
        simulateEvent(new DummyInteraction("bla", 1), eventTarget);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget);
        simulateEvent(new DummyInteraction("blu", 1), eventTarget);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence {" +
             "  Event bla {}" +
             "  Event bli {}" +
             "  Event blo {}" +
             "  Event blu {}" +
             "  Event bla {}" +
             "}", getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testOneInteractionOnManyElements() {
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        IEventTarget eventTarget3 = new DummyGUIElement("elem3");
        IEventTarget eventTarget4 = new DummyGUIElement("elem4");
        IEventTarget eventTarget5 = new DummyGUIElement("elem5");
        IEventTarget eventTarget6 = new DummyGUIElement("elem6");
        simulateEvent(new DummyInteraction("bla", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget2);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget3);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget4);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget5);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget6);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event bli {}" +
             "  }" +
             "  Sequence sequence3 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence4 {" +
             "    Event bli {}" +
             "  }" +
             "  Sequence sequence5 {" +
             "    Event blo {}" +
             "  }" +
             "  Sequence sequence6 {" +
             "    Event bla {}" +
             "  }" +
             "}", getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testManyInteractionsOnManyElementsWithoutHierarchy() {
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        IEventTarget eventTarget3 = new DummyGUIElement("elem3");
        IEventTarget eventTarget4 = new DummyGUIElement("elem4");
        IEventTarget eventTarget5 = new DummyGUIElement("elem5");
        IEventTarget eventTarget6 = new DummyGUIElement("elem6");
        simulateEvent(new DummyInteraction("bla", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget2);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget2);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget3);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget4);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget4);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget4);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget4);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget5);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget6);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget6);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget6);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget6);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event bli {}" +
             "    Event blo {}" +
             "  }" +
             "  Sequence sequence3 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence4 {" +
             "    Event bli {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event blo {}" +
             "  }" +
             "  Sequence sequence5 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence6 {" +
             "    Event bli {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event blo {}" +
             "  }" +
             "}", getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testManyInteractionsOnManyElementsWithHierarchy() {
        DummyGUIElement parentA = new DummyGUIElement("A");
        DummyGUIElement parentB = new DummyGUIElement("B", parentA);
        DummyGUIElement parentC = new DummyGUIElement("C", parentB);
        DummyGUIElement parentF = new DummyGUIElement("F", parentB);
        DummyGUIElement parentH = new DummyGUIElement("H", parentA);
        DummyGUIElement parentI = new DummyGUIElement("I", parentH);
        
        DummyGUIElement eventTargetD = new DummyGUIElement("D", parentC);
        DummyGUIElement eventTargetE = new DummyGUIElement("E", parentC);
        DummyGUIElement eventTargetG = new DummyGUIElement("G", parentF);
        DummyGUIElement eventTargetJ = new DummyGUIElement("J", parentI);
        
        simulateEvent(new DummyInteraction("1", 1), eventTargetD);
        simulateEvent(new DummyInteraction("2", 1), eventTargetD);
        simulateEvent(new DummyInteraction("3", 1), eventTargetE);
        simulateEvent(new DummyInteraction("4", 1), eventTargetD);
        simulateEvent(new DummyInteraction("5", 1), eventTargetG);
        simulateEvent(new DummyInteraction("6", 1), eventTargetG);
        simulateEvent(new DummyInteraction("7", 1), eventTargetD);
        simulateEvent(new DummyInteraction("8", 1), eventTargetJ);
        simulateEvent(new DummyInteraction("9", 1), eventTargetG);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Sequence sequence2 {" +
             "      Sequence sequence3 {" +
             "        Event 1 {}" +
             "        Event 2 {}" +
             "      }" +
             "      Sequence sequence4 {" +
             "        Event 3 {}" +
             "      }" +
             "      Sequence sequence5 {" +
             "        Event 4 {}" +
             "      }" +
             "    }" +
             "    Sequence sequence6 {" +
             "      Event 5 {}" +
             "      Event 6 {}" +
             "    }" +
             "    Sequence sequence7 {" +
             "      Event 7 {}" +
             "    }" +
             "  }" +
             "  Sequence sequence8 {" +
             "    Event 8 {}" +
             "  }" +
             "  Sequence sequence9 {" +
             "    Event 9 {}" +
             "  }" +
             "}", getTaskTree());
    }

}
