
package de.ugoe.cs.autoquest.plugin.jfc.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.IComboBox;

/**
 * <p>
 * Class that represents combo boxes in JFC GUIs.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class JFCComboBox extends JFCGUIElement implements IComboBox {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new JFCComboBox.
     * </p>
     * 
     * @param specification
     *            specification of created GUI element
     * @param parent
     *            parent of the created GUI element; null means that the element is a top-level
     *            window
     */
    public JFCComboBox(JFCGUIElementSpec specification, JFCGUIElement parent) {
        super(specification, parent);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.plugin.jfc.guimodel.JFCGUIElement#getElementDescriptor()
     */
    @Override
    protected String getElementDescriptor() {
        return "ComboBox";
    }

}
