package de.ugoe.cs.autoquest.usageprofiles;

import java.util.List;

/**
 * <p>
 * This interface defines basic functions for classes that implement a memory about the recent
 * events of a sequences.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 * 
 * @param <T>
 *            Type of the sequence elements that are memorized.
 */
public interface IMemory<T> {

    /**
     * Adds an element to the end of the memory.
     * 
     * @param element
     *            Element to be added.
     */
    public void add(T element);

    /**
     * <p>
     * Returns the last <code>num</code> memorized elements. If the history is shorter than
     * <code>num</code>, the length of the returned {@link java.util.List} may be less than
     * <code>num</code>.
     * </p>
     * 
     * @param num
     *            Number of states from the end of the memory to be returned.
     * @return {@link java.util.List} of memorized elements.
     */
    public List<T> getLast(int num);

}
