
package de.ugoe.cs.autoquest.commands.sequences;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.autoquest.SequenceInstanceOf;
import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to remove the {@link Event#STARTEVENT} and {@link Event#ENDEVENT} from a sequence.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public class CMDremoveStartEndSymbols implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @SuppressWarnings("unchecked")
    @Override
    public void run(List<Object> parameters) {
        String sequencesName;
        try {
            sequencesName = (String) parameters.get(0);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }

        Collection<List<Event>> sequences = null;
        Object dataObject = GlobalDataContainer.getInstance().getData(sequencesName);
        if (dataObject == null) {
            CommandHelpers.objectNotFoundMessage(sequencesName);
            return;
        }
        if (!SequenceInstanceOf.isCollectionOfSequences(dataObject)) {
            CommandHelpers.objectNotType(sequencesName, "Collection<List<Event<?>>>");
            return;
        }

        sequences = (Collection<List<Event>>) dataObject;

        for (List<Event> sequence : sequences) {
            Iterator<Event> iter = sequence.iterator();
            while (iter.hasNext()) {
                Event event = iter.next();
                if (Event.ENDEVENT.equals(event) || Event.STARTEVENT.equals(event)) {
                    iter.remove();
                }
            }
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "removeStartEndSymbols <sequences>";
    }

}
