package de.ugoe.cs.autoquest.commands.usage;

import java.util.List;
import java.util.Random;

import de.ugoe.cs.autoquest.usageprofiles.DeterministicFiniteAutomaton;
import de.ugoe.cs.autoquest.usageprofiles.TrieBasedModel;

/**
 * <p>
 * Command to train a Deterministic Finite Automaton (DFA).
 * </p>
 * 
 * @author Steffen Herbold
 * @version 2.0
 */
public class CMDtrainDFA extends AbstractTrainCommand {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "trainDFA <modelname> <sequencesName>";
	}

	/**
	 * <p>
	 * No additional parameters.
	 * </p>
	 * 
	 * @see de.ugoe.cs.autoquest.commands.usage.AbstractTrainCommand#handleAdditionalParameters(java.util.List)
	 */
	@Override
	void handleAdditionalParameters(List<Object> parameters) throws Exception {
		// no additional parameters.
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.ui.commands.AbstractTrainCommand#createModel()
	 */
	@Override
	TrieBasedModel createModel() {
		return new DeterministicFiniteAutomaton(new Random());
	}

}
