package de.ugoe.cs.autoquest;

import java.io.Serializable;

/**
 * <p>
 * This interface defines the structure of decorators used when writing replay
 * files.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface IReplayDecorator extends Serializable {

	/**
	 * <p>
	 * Header of the file. Called at the beginning of the writing.
	 * </p>
	 * 
	 * @return file header
	 */
	String getHeader();

	/**
	 * <p>
	 * Footer of the file. Called at the end of the writing.
	 * </p>
	 * 
	 * @return file footer
	 */
	String getFooter();

	/**
	 * <p>
	 * Session Header. Called before each session.
	 * </p>
	 * 
	 * @param sessionId
	 *            id of the session
	 * @return session header
	 */
	String getSessionHeader(int sessionId);

	/**
	 * <p>
	 * Session Footer. Called after each session.
	 * </p>
	 * 
	 * @param sessionId
	 *            id of the session
	 * @return session footer
	 */
	String getSessionFooter(int sessionId);
}
