package de.ugoe.cs.autoquest;

import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;

import de.ugoe.cs.autoquest.eventcore.Event;

/**
 * <p>
 * Helper class that can be used to determine if an object is a sequence or a
 * collection of sequences. {@code instanceof} does not work, because of
 * the type erasure of generics.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class SequenceInstanceOf {
	
	/**
	 * <p>
	 * Private constructor to prevent initializing of the class.
	 * </p>
	 */
	private SequenceInstanceOf() {
		
	}

	/**
	 * <p>
	 * Checks if an object is of type {@link Collection}&lt;{@link List}&lt;
	 * {@link Event}&lt;?&gt;&gt;&gt;.
	 * </p>
	 * 
	 * @param obj
	 *            object that is checked
	 * @return true, if the obj is of type {@link Collection}&lt;{@link List}
	 *         &lt; {@link Event}&lt;?&gt;&gt;&gt;; false otherwise
	 */
	public static boolean isCollectionOfSequences(Object obj) {
		try {
			if (obj instanceof Collection<?>) {
				Object listObj = ((Collection<?>) obj).iterator().next();
				if (listObj instanceof List<?>) {
					if (((List<?>) listObj).iterator().next() instanceof Event) {
						return true;
					}
				}
			}
		} catch (NoSuchElementException e) {
		}
		return false;
	}

	/**
	 * <p>
	 * Checks if an object is of type {@link List}&lt;{@link Event}
	 * &lt;?&gt;&gt;.
	 * </p>
	 * 
	 * @param obj
	 *            object that is checked
	 * @return true, if obj is of type {@link List}&lt;{@link Event}
	 *         &lt;?&gt;&gt;; false otherwise
	 */
	public static boolean isEventSequence(Object obj) {
		try {
			if (obj instanceof List<?>) {
				if (((List<?>) obj).iterator().next() instanceof Event) {
					return true;
				}
			}
		} catch (NoSuchElementException e) {
		}
		return false;
	}

}
