
package de.ugoe.cs.autoquest.eventcore;

import java.io.Serializable;

/**
 * <p>
 * Common interface for event targets. An event target can, e.g., be an element of a GUI or Web
 * server. A concrete event-driven software platform can define its event targets through the
 * implementation of this interface.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public interface IEventTarget extends Serializable {

    /**
     * <p>
     * Returns the name of event-driven software platform to which the target belongs.
     * </p>
     * 
     * @return name of the platform
     */
    public String getPlatform();

    /**
     * <p>
     * Returns a string identifier of the target. This is very convenient for visualizations of
     * events.
     * </p>
     * 
     * @return target identifier
     */
    public String getStringIdentifier();
}
