
package de.ugoe.cs.autoquest.eventcore.gui;

import de.ugoe.cs.autoquest.eventcore.IEventType;

/**
 * <p>
 * An interaction is a special event type which represents the interaction of a user with an element
 * of a GUI. An example is a mouse click on a button.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public interface IInteraction extends IEventType {
    /**
     * <p>
     * Determines whether an event type starts a logical sequence, i.e., a task.
     * </p>
     * 
     * @return true if a logical sequence is started; false otherwise
     */
    public boolean startsLogicalSequence();

    /**
     * <p>
     * Determines whether an event type finishes a logical sequence, i.e., a task.
     * </p>
     * 
     * @return true if a logical sequence is finished; false otherwise
     */
    public boolean finishesLogicalSequence();

}
