
package de.ugoe.cs.autoquest.eventcore.gui;

import de.ugoe.cs.autoquest.keyboardmaps.VirtualKey;

/**
 * <p>
 * Event type for pressing down a key.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class KeyPressed extends KeyInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new {@link KeyPressed} event type.
     * </p>
     * 
     * @see KeyInteraction#KeyInteraction(VirtualKey)
     */
    public KeyPressed(VirtualKey key) {
        super(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        return "KeyPressed " + super.getKey();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "pressing key " + super.getKey();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#startsLogicalSequence()
     */
    public boolean startsLogicalSequence() {
        // TODO handle lock keys correctly
        return super.getKey().isCombinationKey();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#finishesLogicalSequence()
     */
    public boolean finishesLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object other) {
        if (other instanceof KeyPressed) {
            return (super.getKey() == ((KeyPressed) other).getKey());
        }
        else {
            return false;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return super.getKey().hashCode();
    }

}
