
package de.ugoe.cs.autoquest.eventcore.gui;

/**
 * <p>
 * Event type for releasing a mouse button.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class MouseButtonUp extends MouseButtonInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new {@link MouseButtonUp} event type.
     * </p>
     * 
     * @see MouseButtonInteraction#MouseButtonInteraction(Button)
     */
    public MouseButtonUp(Button button) {
        super(button);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        if (super.getButton() == Button.LEFT) {
            return "LeftMouseButtonUp";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "MiddleMouseButtonUp";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "RightMouseButtonUp";
        }
        else {
            return "UnknownMouseButtonUp";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        if (super.getButton() == Button.LEFT) {
            return "left mouse button up";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "middle mouse button up";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "right mouse button up";
        }
        else {
            return "unknown mouse button up";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#startsLogicalSequence()
     */
    public boolean startsLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#finishesLogicalSequence()
     */
    public boolean finishesLogicalSequence() {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MouseButtonUp) {
            return getButton().equals(((MouseButtonUp) obj).getButton());
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getButton().hashCode();
    }
}
