
package de.ugoe.cs.autoquest.eventcore.gui;

/**
 * <p>
 * Event type for a mouse click, i.e., pressing and releasing it right away.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class MouseClick extends MouseButtonInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new {@link MouseClick} event type.
     * </p>
     * 
     * @see MouseButtonInteraction#MouseButtonInteraction(Button)
     */
    public MouseClick(Button button) {
        super(button);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        if (super.getButton() == Button.LEFT) {
            return "LeftMouseClick";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "MiddleMouseClick";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "RightMouseClick";
        }
        else {
            return "UnknownMouseButtonClick";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        if (super.getButton() == Button.LEFT) {
            return "left mouse click";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "middle mouse click";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "right mouse click";
        }
        else {
            return "unknown mouse button click";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#startsLogicalSequence()
     */
    public boolean startsLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#finishesLogicalSequence()
     */
    public boolean finishesLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MouseClick) {
            return getButton().equals(((MouseClick) obj).getButton());
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getButton().hashCode();
    }
}
