
package de.ugoe.cs.autoquest.eventcore.guimodel;

/**
 * <p>
 * Exception that is thrown if there are problems with the {@link GUIModel}.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class GUIModelException extends Exception {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new GUIModelException.
     * </p>
     */
    public GUIModelException() {
        super();
    }

    /**
     * <p>
     * Constructor. Creates a new GUIModelException.
     * </p>
     * 
     * @param message
     *            message of the exception
     */
    public GUIModelException(String message) {
        super(message);
    }

    /**
     * <p>
     * Constructor. Creates a new GUIModelException.
     * </p>
     * 
     * @param cause
     *            cause of the exception
     */
    public GUIModelException(Throwable cause) {
        super(cause);
    }

    /**
     * <p>
     * Constructor. Creates a new GUIModelException.
     * </p>
     * 
     * @param message
     *            message of the exception
     * @param cause
     *            cause of the exception
     */
    public GUIModelException(String message, Throwable cause) {
        super(message, cause);
    }

}
