
package de.ugoe.cs.autoquest.eventcore.guimodel;

import java.io.Serializable;

/**
 * <p>
 * Common interface for GUI element specifications.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public interface IGUIElementSpec extends Serializable {

    /**
     * <p>
     * Returns a string represenation of the GUI element type that this specification represents.
     * </p>
     * 
     * @return
     */
    public String getType();

    /**
     * <p>
     * Evaluates if two GUI specifications are similar. Similar means that a heuristic determines
     * that the two GUI specifications describe the same GUI element.
     * </p>
     * 
     * @param other
     *            specification whose similarity to this is evaluated
     * @return true if the specifications are similar; false otherwise
     */
    public boolean getSimilarity(IGUIElementSpec other);

    /**
     * <p>
     * Defines that {@link IGUIElement} implementations have to define equals.
     * </p>
     * 
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object other);

    /**
     * <p>
     * Defines that {@link IGUIElement} implementations have to define hashCode.
     * </p>
     * 
     * @see Object#hashCode()
     */
    @Override
    public int hashCode();
}
